IF EXISTS(SELECT * FROM sys.triggers
  WHERE object_id=OBJECT_ID(N'[dbo].[TRG_EST_PROD_ULT_MOV_PDV]') )
    DROP TRIGGER [dbo].[TRG_EST_PROD_ULT_MOV_PDV];
GO
/*  
=======================================================================================  
'localizado..........:   
'Funo..............:   
'Objetivo............:    
'Tabelas.............: EST_PROD_CPL_VD_LOTE_PROC_PENDENTE | EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL | EST_PROD_CPL_VD_LOTE_PROC_EST_PROD  
'Dt Modificao......: 25/10/2023 
'Modificao.........: Jerfeson Barbosa
'=======================================================================================  
Tag #A001 - Alterao do codigo    
Tag #I001 - Incluso de novo codigo     
Tag #A001 - Alterao do codigo: Tratamento para filtrar o menor cdigo  CD_CTR no insert temporrio EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_CD_CTR;
Tag #A001 - Alterao do codigo: Adcionado ISNULL na coluna ISNULL(TX_RED_IT,0) 
*/  
  
CREATE TRIGGER [dbo].[TRG_EST_PROD_ULT_MOV_PDV] ON [dbo].[PDV_VD_IT]
FOR INSERT,UPDATE  
AS      
  
IF CONTEXT_INFO() = 0x66666
    RETURN
  
/*************************************************************************************************************************/
/*Dados para processamento de informacao de vendas para BI */  
   
BEGIN  
    DECLARE @EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_CD_CTR TABLE (CD_CTR INT,CD_CTR_DT_MOVIMENTO INT);
   
    BEGIN
          
  INSERT INTO @EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_CD_CTR  
  SELECT
    MIN(CD_CTR),
             GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO              
        FROM  
            GLB_DT_MOVIMENTO  
   INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_PENDENTE P  WITH(NOLOCK) ON
   P.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
            INNER JOIN INSERTED I ON   
    GLB_DT_MOVIMENTO.DT_MOVIMENTO =CONVERT (DATE ,I.DT_VD)
  GROUP BY  GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
  
  
  IF NOT EXISTS(SELECT * FROM @EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_CD_CTR)
  BEGIN  
   INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_PENDENTE( CD_CTR_DT_MOVIMENTO
               ,DT_CAD
               ,ANO  
               ,MES  
               ,ANO_MES  
               ,ROTINA)  
     OUTPUT INSERTED.CD_CTR ,INSERTED.CD_CTR_DT_MOVIMENTO INTO @EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_CD_CTR  
   SELECT DISTINCT  
     GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO  
    ,GETDATE()  
    ,GLB_DT_MOVIMENTO.ANO_MOVIMENTO  
    ,GLB_DT_MOVIMENTO.MES_MOVIMENTO  
    ,GLB_DT_MOVIMENTO.ANO_MES_MOVIMENTO  
    ,OBJECT_NAME(@@PROCID)  
   FROM  
    GLB_DT_MOVIMENTO  
    INNER JOIN INSERTED I ON GLB_DT_MOVIMENTO.DT_MOVIMENTO =CONVERT (DATE ,I.DT_VD)
  END
  
        /*SET @CD_CTR=SCOPE_IDENTITY(); --IDENT_CURRENT('EST_PROD_CPL_VD_LOTE_PROC_PENDENTE'); */
     
  
        IF NOT EXISTS (SELECT 1 FROM @EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_CD_CTR)
            RETURN;
  
   
  
        INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL(CD_CTR,CD_EMP,CD_FILIAL)
        SELECT DISTINCT  
             pend.CD_CTR
            ,I.CD_EMP
            ,I.CD_FILIAL  
        FROM  
            INSERTED AS I   
            INNER JOIN GLB_DT_MOVIMENTO ON GLB_DT_MOVIMENTO.DT_MOVIMENTO =CONVERT (DATE ,I.DT_VD)  
            INNER JOIN @EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_CD_CTR PEND ON PEND.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO   
   LEFT OUTER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL T ON    I.CD_EMP=T.CD_EMP  
                  AND I.CD_FILIAL=T.CD_FILIAL
                  AND pend.CD_CTR=T.CD_CTR
  WHERE   
   T.CD_FILIAL IS NULL;
   
  
        INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_EST_PROD(CD_CTR  
                                                        ,CD_EMP  
                                                        ,CD_PROD)  
        SELECT DISTINCT
             pend.CD_CTR
            ,I.CD_EMP
            ,I.CD_PROD
        FROM  
            INSERTED AS I  
            INNER JOIN GLB_DT_MOVIMENTO ON GLB_DT_MOVIMENTO.DT_MOVIMENTO =CONVERT (DATE ,I.DT_VD)  
            INNER JOIN @EST_PROD_CPL_VD_LOTE_PROC_PENDENTE_CD_CTR PEND ON PEND.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO  
            LEFT OUTER JOIN EST_PROD_CPL_VD_LOTE_PROC_EST_PROD ON I.CD_EMP=EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_EMP  
                                                              AND I.CD_PROD=EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD  
            AND pend.CD_CTR=EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_CTR  
        WHERE   
            EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD IS NULL;  
  
   
  
    END;  
END;  
  
   
  
/*Controle de atualizacao de tributacao */  
IF UPDATE(CD_TRIB_FC) OR UPDATE(TX_ICMS_IT)  
                       OR UPDATE(TX_RED_IT)  
                       OR UPDATE(CST_PIS)  
                       OR UPDATE(CST_COFINS)  
                       OR UPDATE(PERC_ALIQ_PIS)  
                       OR UPDATE(PERC_ALIQ_COFINS)  
BEGIN  
    /*atualiza registros ja existentes de produto e filial com a nova ultima venda*/  
--Tag #A001
    INSERT INTO PDV_VD_IT_FISCAL_ALTERACAO(CD_EMP  
                                            ,CD_FILIAL  
                                            ,CD_VD  
                                            ,CD_IT  
                                            ,CD_TRIB_FC  
                                            ,TX_ICMS_IT  
                                            ,TX_RED_IT  
                                            ,CD_USU  
                                            ,DT_CAD  
                                            ,CST_PIS  
                                            ,CST_COFINS  
                                            ,PERC_ALIQ_PIS  
                                            ,PERC_ALIQ_COFINS) 
    SELECT  
         CD_EMP  
        ,CD_FILIAL  
        ,CD_VD  
        ,CD_IT  
        ,ISNULL(CD_TRIB_FC,'')
        ,TX_ICMS_IT  
        ,ISNULL(TX_RED_IT,0)  
        ,0  
        ,GETDATE()  
        ,CST_PIS  
        ,CST_COFINS  
        ,PERC_ALIQ_PIS  
        ,PERC_ALIQ_COFINS  
    FROM  
         DELETED;  
END;
GO

ALTER TABLE [dbo].[PDV_VD_IT] ENABLE TRIGGER [TRG_EST_PROD_ULT_MOV_PDV]
GO


